function rgbout1_hyb(string,strength,m,b,shiftmat,chprofile)
% write 4-channel images into 8-bit rgb images for display. The four
% channels are assigned as Cyan, Yellow, Magenta, and White. m indicates
% median filter size (0 = no median filtering). b indicates ball radius for
% top hat filtering (0 = no filtering).This version adds the option of shifting channels
%to correct for dichroic thickness. shiftmat is 4 x 2 for 4 channels. Each
%row is [Tx Ty].
if ~exist('m','var')
    m=0;
end
if ~exist('b','var')
    b=0;
end
if ~exist('shiftmat','var')
    shiftmat=zeros(6,2);
end
if isempty(shiftmat)
    shiftmat=zeros(6,2);
end
    

if m<=3&&m>0
    m=3;
end

if ~exist('chprofile','var')
    chprofile=[];
end



fileselection=strcat(string,'*.tif');
files=dir(fullfile(fileselection));
files={files.name};
L=size(files);

for k=1:L(2)
    currentfile=files{k};
    imgGFP=imtranslate(imread(currentfile,1),shiftmat(1,:))*strength(1);%cyan
    imgYFP=imtranslate(imread(currentfile,2),shiftmat(2,:))*strength(2);%yellow
    imgTxRed=imtranslate(imread(currentfile,3),shiftmat(3,:))*strength(3);%red
    imgCy5=imtranslate(imread(currentfile,4),shiftmat(4,:))*strength(4);%magenta
    imgDAPI=imtranslate(imread(currentfile,5),shiftmat(5,:))*strength(5);%blue
    imgDIC=imtranslate(imread(currentfile,6),shiftmat(6,:))*strength(6);%white
    
    if m>0
        imgGFP=medfilt2(imgGFP,[m m]);
        imgYFP=medfilt2(imgYFP,[m m]);
        imgTxRed=medfilt2(imgTxRed,[m m]);
        imgCy5=medfilt2(imgCy5,[m m]);
        imgDAPI=medfilt2(imgDAPI,[m m]);
        
    end
    if b>0
        se=offsetstrel('ball',b,b);
        imgGFP=imtophat(imgGFP,se);
        imgYFP=imtophat(imgYFP,se);
        imgTxRed=imtophat(imgTxRed,se);
        imgCy5=imtophat(imgCy5,se);
        imgDAPI=imtophat(imgDAPI,se);
    end
    
    if ~isempty(chprofile)
        im=imgGFP;im(:,:,2)=imgYFP;im(:,:,3)=imgTxRed;im(:,:,4)=imgCy5;
        im=reshape(uint16(double(reshape(im,[],4))/chprofile),size(im,1),size(im,2),4);%correct for bleeding
        imgGFP=im(:,:,1);
        imgYFP=im(:,:,2);
        imgTxRed=im(:,:,3);
        imgCy5=im(:,:,4);
    end
% 
%     [p,n]=size(imgGFP);
%     imageRGB(1:p,1:n,1:3)=0;
%     imageRGB(1:p,1:n,1)=double(imgYFP+imgTxRed+imgCy5+imgDIC);
%     imageRGB(1:p,1:n,2)=double(imgYFP+imgGFP+imgDIC);
%     imageRGB(1:p,1:n,3)=double(imgDAPI+imgGFP+imgCy5+imgDIC);
    
    imageRGB=repmat(zeros(size(imgGFP)),1,1,3);
    imageRGB(:,:,1)=double(max(cat(3,imgYFP,imgTxRed,imgCy5,imgDIC),[],3));
    imageRGB(:,:,2)=double(max(cat(3,imgYFP,imgGFP,imgDIC),[],3));
    imageRGB(:,:,3)=double(max(cat(3,imgDAPI,imgGFP,imgCy5,imgDIC),[],3));
    



    imageRGB=uint8(imageRGB);
    filename=strcat('RGB',currentfile);
    imwrite(imageRGB, filename);
end
end


